<?php

class SimpleFileReader {
    private $data;
    private $pos = 0;
    function __construct($filename) {
        $this->data = file_get_contents($filename);
    }
    function read($bytes) {
        $result = substr($this->data, $this->pos, $bytes);
        $this->pos += $bytes;
        return $result;
    }
    function seekto($pos) {
        $this->pos = $pos;
    }
}

require_once('streams.php');
require_once('gettext.php');


switch (substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2)) {
    case 'ru':
        $language = 'ruso';
        break;
    case 'de':
        $language = 'aleman';
        break;
    case 'fr':
        $language = 'france';
        break;
    case 'it':
        $language = 'Italiano';
        break;
    case 'pt':
        $language = 'Portugues';
        break;
    case 'es':
        $language = 'Spanish';
        break;
    case 'en':
        $language = 'English';
        break;
    default:
        $language = 'English';
        break;
}

if ($_SESSION['VERSION'] == 'MOBILE') {
    $mo_path = $pach . '../../php/php-gettext/language/' . $language . '.mo';
} else {
    $mo_path = $pach . '../php/php-gettext/language/' . $language . '.mo';
}

file_put_contents("debug_ruta.txt", $mo_path);

if (file_exists($mo_path)) {
    $gettext_tables = new gettext_reader(new SimpleFileReader($mo_path));
    $gettext_tables->load_tables();
    file_put_contents("debug_gettext.txt", print_r($gettext_tables, true));
} else {
    file_put_contents("errorkm.txt", "No se encontró el archivo de traducción en: " . $mo_path);
    exit("No se encontró el archivo de traducción");
}

function __($text)
{
    global $gettext_tables;
    return (is_null($gettext_tables) ? $text : $gettext_tables->translate($text));
}

function _e($text)
{
    global $gettext_tables;
    echo (is_null($gettext_tables) ? $text : $gettext_tables->translate($text));
}

?>