<?php
/**
 * 🗂️ Configuración de Rutas del Sistema AntiBot
 * 
 * Centraliza todas las rutas del sistema para fácil mantenimiento
 */

return [
    // Directorio base del sistema
    'base_dir' => __DIR__,
    
    // Carpetas del sistema
    'directories' => [
        'cache' => __DIR__ . '/cache',
        'data' => __DIR__ . '/data',
        'logs' => __DIR__ . '/logs'
    ],
    
    // Archivos del sistema
    'files' => [
        'blacklist' => __DIR__ . '/data/ip_blacklist.txt',
        'log' => __DIR__ . '/logs/antibot_log.txt',
        'config' => __DIR__ . '/config.php',
        'ipdetective_config' => __DIR__ . '/ipdetective_config.php'
    ],
    
    // Extensiones de archivos
    'extensions' => [
        'cache' => '.cache',
        'log' => '.log',
        'config' => '.php'
    ],
    
    // Permisos por defecto
    'permissions' => [
        'directory' => 0755,
        'file' => 0644
    ],
    
    // Configuración de cURL optimizada
    'curl' => [
        'timeout' => 2,
        'connect_timeout' => 1,
        'user_agent' => 'AntiBot System/1.0',
        'headers' => [
            'Accept: application/json',
            'Connection: close'
        ]
    ]
];
?>
