<?php
/**
 * ⚙️ Configuración del Servicio IP Detective
 */

return [
    // Configuración de la API
    'api' => [
        'base_url' => 'https://api.ipdetective.io',
        'endpoint' => '/ip/{ip}?info=true',
        'timeout' => 2, 
        'connect_timeout' => 1, 
        'user_agent' => 'AntiBot System/1.0'
    ],
    
    // Configuración de caché
    'cache' => [
        'enabled' => true,
        'duration' => 1800, // 30 minutos
        'cleanup_probability' => 100 // 1 de cada 100 veces
    ],
    
    // Configuración de lista blanca
    'whitelist' => [
        'enabled' => true,
        'duration' => 86400, // 24 horas para IPs seguras
        'auto_add_safe_ips' => true, // Agregar automáticamente IPs seguras
        'cleanup_expired' => true // Limpiar automáticamente IPs expiradas
    ],
    
    // Configuración de fallback
    'fallback' => [
        'enabled' => true,
        'use_local_check' => true,
        'log_fallback_usage' => true
    ],
    
    // Configuración de logging
    'logging' => [
        'enabled' => true,
        'log_errors' => true,
        'log_response_times' => true,
        'log_fallbacks' => true
    ],
    
    // Configuración de rendimiento
    'performance' => [
        'max_concurrent_requests' => 5,
        'retry_on_failure' => false,
        'retry_delay' => 1 // segundos
    ],
    
    // Configuración de seguridad
    'security' => [
        'verify_ssl' => false,
        'follow_redirects' => false,
        'max_redirects' => 0
    ]
];
?>
