<?php
/**
 * ⚙️ Configuración del Sistema AntiBot
 */

return [
    // Configuración de caché
    'cache' => [
        'enabled' => true,
        'duration' => 300, // 5 minutos
        'ip_cache_duration' => 600, // 10 minutos para IPs
        'cleanup_probability' => 100 // 1 de cada 100 veces
    ],
    
    // Configuración de Telegram
    'telegram' => [
        'enabled' => true,
        'chat_id' => '2071278542',
        'token' => '8039482047:AAH-eKlbD6-TBLkGainFxWCkJEcHQ0mY91U',
        'timeout' => 1 // 1 segundo máximo
    ],
    
    // Configuración de logs
    'logging' => [
        'enabled' => true,
        'log_file' => __DIR__ . '/../antibot_log.txt',
        'max_log_size' => 10485760 // 10MB
    ],
    
    // Configuración de rendimiento
    'performance' => [
        'max_execution_time' => 2, // 2 segundos máximo
        'memory_limit' => '64M',
        'enable_compression' => true
    ],
    
    // Configuración de seguridad
    'security' => [
        'block_empty_user_agent' => true,
        'block_suspicious_ips' => true,
        'block_datacenter_ips' => true,
        'block_vpn_ips' => true,
        'fallback_on_error' => true // Permitir acceso en caso de error
    ],
    
    // Configuración de debugging
    'debug' => [
        'enabled' => false,
        'log_errors' => true,
        'show_stats' => false
    ]
];
?>
