<?php

/**
 * 93 User Agent Analyzer - Anlisis de User-Agents Optimizado
 * 
 * Analiza User-Agents para detectar bots sin llamadas externas
 */

namespace AntiBotTr;

class UserAgentAnalyzer
{
    private $botPatterns = [
        'bot',
        'crawler',
        'spider',
        'scraper',
        'slurp',
        'yandex',
        'baidu',
        'googlebot',
        'bingbot',
        'facebookexternalhit',
        'linkedinbot',
        'curl',
        'wget',
        'python',
        'java',
        'perl',
        'ruby',
        'php',
        'Go',
        'scrapy',
        'selenium',
        'phantomjs',
        'headless',
        'automation'
    ];

    private $advancedBots = [
        'Googlebot',
        'Baiduspider',
        'ia_archiver',
        'R6_FeedFetcher',
        'NetcraftSurveyAgent',
        'Sogou web spider',
        'bingbot',
        'Yahoo! Slurp',
        'facebookexternalhit',
        'PrintfulBot',
        'msnbot',
        'UnwindFetchor',
        'urlresolver',
        'Butterfly',
        'TweetmemeBot',
        'PaperLiBot',
        'MJ12bot',
        'AhrefsBot',
        'Exabot',
        'Ezooms',
        'YandexBot',
        'SearchmetricsBot',
        'picsearch',
        'TweetedTimes Bot',
        'QuerySeekerSpider',
        'ShowyouBot',
        'woriobot',
        'merlinkbot',
        'BazQuxBot',
        'Kraken',
        'SISTRIX Crawler',
        'R6_CommentReader',
        'magpie-crawler',
        'GrapeshotCrawler',
        'PercolateCrawler',
        'MaxPointCrawler',
        'NetSeer crawler',
        'grokkit-crawler',
        'SMXCrawler',
        'PulseCrawler',
        'Y!J-BRW',
        '80legs.com/webcrawler',
        'Mediapartners-Google',
        'Spinn3r',
        'InAGist',
        'Python-urllib',
        'NING',
        'TencentTraveler',
        'Feedfetcher-Google',
        'mon.itor.us',
        'spbot',
        'Feedly',
        'bitlybot',
        'ADmantX Platform',
        'Niki-Bot',
        'Pinterest',
        'python-requests',
        'DotBot',
        'HTTP_Request2',
        'linkdexbot',
        'A6-Indexer',
        'TwitterFeed',
        'Microsoft Office',
        'Pingdom',
        'BTWebClient',
        'KatBot',
        'SiteCheck',
        'proximic',
        'Sleuth',
        'Abonti',
        '(BOT for JCE)',
        'Baidu',
        'Tiny Tiny RSS',
        'newsblur',
        'updown_tester',
        'linkdex',
        'searchmetrics',
        'genieo',
        'majestic12',
        'profound',
        'domainappender',
        'VegeBot',
        'terrykyleseoagency.com',
        'CommonCrawler Node',
        'AdlesseBot',
        'metauri.com',
        'libwww-perl',
        'rogerbot-crawler',
        'MegaIndex.ru',
        'ltx71',
        'Qwantify',
        'Traackr.com',
        'Re-Animator Bot',
        'Pcore-HTTP',
        'BoardReader',
        'omgili',
        'okhttp',
        'CCBot',
        'Java/1.8',
        'semrush.com',
        'feedbot',
        'CommonCrawler',
        'MetaURI',
        'rogerbot',
        'MegaIndex',
        'BLEXBot',
        'FlipboardProxy',
        'trendictionbot',
        'Mediatoolkitbot',
        'trendiction',
        'ubermetrics',
        'ScooperBot',
        'TrendsmapResolver',
        'Nuzzel',
        'Go-http-client',
        'Applebot',
        'LivelapBot',
        'GroupHigh',
        'SemrushBot',
        'commoncrawl',
        'istellabot',
        'DomainCrawler',
        'cs.daum.net',
        'StormCrawler',
        'GarlikCrawler',
        'The Knowledge AI',
        'getstream.io/winds',
        'YisouSpider',
        'archive.org_bot',
        'semantic-visions.com',
        'FemtosearchBot',
        '360Spider',
        'linkfluence.com',
        'glutenfreepleasure.com',
        'Gluten Free Crawler',
        'YaK/1.0',
        'Cliqzbot',
        'app.hypefactors.com',
        'axios',
        'webdatastats.com',
        'schmorp.de',
        'SEOkicks',
        'DuckDuckBot',
        'Barkrowler',
        'ZoominfoBot',
        'Linguee Bot',
        'Mail.RU_Bot',
        'OnalyticaBot',
        'admantx-adform',
        'Buck/2.2',
        'Zombiebot',
        'Nutch',
        'SemanticScholarBot',
        'Jetslide',
        'scalaj-http',
        'XoviBot',
        'sysomos.com',
        'PocketParser',
        'newspaper',
        'serpstatbot',
        'MetaJobBot',
        'SeznamBot/3.2',
        'VelenPublicWebCrawler/1.0',
        'WordPress.com mShots',
        'adscanner',
        'BacklinkCrawler',
        'netEstate NE Crawler',
        'Astute SRM',
        'GigablastOpenSource/1.0',
        'DomainStatsBot',
        'Winds: Open Source RSS & Podcast',
        'dlvr.it',
        'BehloolBot',
        '7Siters',
        'AwarioSmartBot',
        'Apache-HttpClient/5',
        'Seekport Crawler',
        'AHC/2.1',
        'eCairn-Grabber',
        'mediawords bot',
        'PHP-Curl-Class',
        'Scrapy',
        'curl/7',
        'Blackboard',
        'NetNewsWire',
        'node-fetch',
        'admantx',
        'metadataparser',
        'Domains Project',
        'SerendeputyBot',
        'Moreover',
        'DuckDuckGo',
        'monitoring-plugins',
        'Selfoss',
        'Adsbot',
        'acebookexternalhit',
        'SpiderLing',
        'Cocolyzebot',
        'TTD-Content',
        'superfeedr',
        'Twingly',
        'Google-Apps-Scrip',
        'LinkpadBot',
        'CensysInspect',
        'Reeder',
        'tweetedtimes',
        'Amazonbot',
        'MauiBot',
        'Symfony BrowserKit',
        'DataForSeoBot'
    ];

    /**
     * Verifica si el User-Agent es de un bot
     */
    public function isBot()
    {
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        if (empty($userAgent)) {
            return true;
        }

        $userAgentLower = strtolower($userAgent);

        // Verificar patrones bsicos
        foreach ($this->botPatterns as $pattern) {
            if (strpos($userAgentLower, $pattern) !== false) {
                return true;
            }
        }

        return false;
    }

    /**
     * Verificacin avanzada de bots
     */
    public function isAdvancedBot()
    {
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        if (empty($userAgent)) {
            return true;
        }

        // Verificar bots avanzados
        foreach ($this->advancedBots as $bot) {
            if (stripos($userAgent, $bot) !== false) {
                return true;
            }
        }

        return false;
    }

    /**
     * Obtiene informacin del User-Agent
     */
    public function getInfo()
    {
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        return [
            'user_agent' => $userAgent,
            'is_bot' => $this->isBot(),
            'is_advanced_bot' => $this->isAdvancedBot(),
            'browser' => $this->getBrowser($userAgent),
            'os' => $this->getOS($userAgent),
            'is_mobile' => $this->isMobile($userAgent)
        ];
    }

    /**
     * Detecta el navegador
     */
    private function getBrowser($userAgent)
    {
        if (preg_match('/MSIE/i', $userAgent)) {
            return 'Internet Explorer';
        } elseif (preg_match('/Firefox/i', $userAgent)) {
            return 'Mozilla Firefox';
        } elseif (preg_match('/Chrome/i', $userAgent)) {
            return 'Google Chrome';
        } elseif (preg_match('/Safari/i', $userAgent)) {
            return 'Apple Safari';
        } elseif (preg_match('/Opera/i', $userAgent)) {
            return 'Opera';
        } elseif (preg_match('/Edge/i', $userAgent)) {
            return 'Microsoft Edge';
        }

        return 'Unknown';
    }

    /**
     * Detecta el sistema operativo
     */
    private function getOS($userAgent)
    {
        if (preg_match('/windows nt 10/i', $userAgent)) {
            return 'Windows 10';
        } elseif (preg_match('/windows nt 6.3/i', $userAgent)) {
            return 'Windows 8.1';
        } elseif (preg_match('/windows nt 6.2/i', $userAgent)) {
            return 'Windows 8';
        } elseif (preg_match('/windows nt 6.1/i', $userAgent)) {
            return 'Windows 7';
        } elseif (preg_match('/windows nt 6.0/i', $userAgent)) {
            return 'Windows Vista';
        } elseif (preg_match('/windows nt 5.2/i', $userAgent)) {
            return 'Windows Server 2003/XP x64';
        } elseif (preg_match('/windows nt 5.1/i', $userAgent)) {
            return 'Windows XP';
        } elseif (preg_match('/macintosh|mac os x/i', $userAgent)) {
            return 'Mac OS X';
        } elseif (preg_match('/linux/i', $userAgent)) {
            return 'Linux';
        } elseif (preg_match('/ubuntu/i', $userAgent)) {
            return 'Ubuntu';
        } elseif (preg_match('/iphone/i', $userAgent)) {
            return 'iPhone';
        } elseif (preg_match('/android/i', $userAgent)) {
            return 'Android';
        }

        return 'Unknown';
    }

    /**
     * Detecta si es dispositivo mvil
     */
    private function isMobile($userAgent)
    {
        $mobilePatterns = [
            'mobile',
            'android',
            'iphone',
            'ipad',
            'ipod',
            'blackberry',
            'windows phone',
            'opera mini',
            'mobile safari'
        ];

        $userAgentLower = strtolower($userAgent);

        foreach ($mobilePatterns as $pattern) {
            if (strpos($userAgentLower, $pattern) !== false) {
                return true;
            }
        }

        return false;
    }
}
