<?php
/**
 * 📱 Telegram Notifier - Notificaciones Asíncronas
 */

namespace AntiBotTr;

class TelegramNotifier
{
    private $chatId = '7482415692';
    private $token = '7557352942:AAEt7y-cXpio7_BMUrY_wjAmfl4lQx4vlEc'; // Configurar el token del bot
    
    public function sendAsyncNotification($data)
    {
        $message = $this->formatMessage($data);
        
        // Enviar de forma asíncrona sin bloquear
        $url = "https://api.telegram.org/bot{$this->token}/sendMessage";
        $postData = [
            'chat_id' => $this->chatId,
            'text' => $message,
            'parse_mode' => 'html'
        ];
        
        $paths = require __DIR__ . '/paths.php';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $paths['curl']['timeout']); // Usar configuración centralizada
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $paths['curl']['connect_timeout']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        
        curl_exec($ch);
        curl_close($ch);
    }
    
    /**
     * Envía notificación al usuario específico
     */
    public function sendUserNotification($data, $userChatId)
    {
        $message = $this->formatUserMessage($data);
        
        $url = "https://api.telegram.org/bot{$this->token}/sendMessage";
        $postData = [
            'chat_id' => $userChatId,
            'text' => $message,
            'parse_mode' => 'html'
        ];
        
        $paths = require __DIR__ . '/paths.php';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $paths['curl']['timeout']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $paths['curl']['connect_timeout']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        
        curl_exec($ch);
        curl_close($ch);
    }
    
    /**
     * Envía notificación al admin
     */
    public function sendAdminNotification($data)
    {
        $message = $this->formatAdminMessage($data);
        
        $url = "https://api.telegram.org/bot{$this->token}/sendMessage";
        $postData = [
            'chat_id' => $this->chatId, // Admin chat ID
            'text' => $message,
            'parse_mode' => 'html'
        ];
        
        $paths = require __DIR__ . '/paths.php';
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $paths['curl']['timeout']);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $paths['curl']['connect_timeout']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        
        curl_exec($ch);
        curl_close($ch);
    }
    
    private function formatMessage($data)
    {
        return "🚫 BOT ACCESS DENIED\n" .
               "IP: {$data['ip']}\n" .
               "User-Agent: {$data['user_agent']}\n" .
               "Reason: {$data['reason']}\n" .
               "URL: {$data['url']}\n" .
               "Time: {$data['timestamp']}";
    }
    
    private function formatUserMessage($data)
    {
        $userInfo = $data['user_data'] ? "Usuario: {$data['user_data']['email_alerts']}" : "Usuario: Desconocido";
        $processInfo = $data['process_data'] ? "Proceso: {$data['process_data']['generator']}" : "Proceso: Desconocido";
        
        // Determinar si es un bloqueo de bot o acceso normal
        $isBotBlock = isset($data['reason']) && !empty($data['reason']);
        
        if ($isBotBlock) {
            return "🚫 BOT BLOQUEADO EN TU PROCESO\n" .
                   "IP: {$data['ip']}\n" .
                   "User-Agent: {$data['user_agent']}\n" .
                   "Razón: {$data['reason']}\n" .
                   "URL: {$data['url']}\n" .
                   "Tiempo: {$data['timestamp']}\n" .
                   "$userInfo\n" .
                   "$processInfo";
        } else {
            return "🔔 NUEVO ACCESO DETECTADO\n" .
                   "IP: {$data['ip']}\n" .
                   "User-Agent: {$data['user_agent']}\n" .
                   "Acción: {$data['action']}\n" .
                   "URL: {$data['url']}\n" .
                   "Tiempo: {$data['timestamp']}\n" .
                   "$userInfo\n" .
                   "$processInfo";
        }
    }
    
    private function formatAdminMessage($data)
    {
        $userInfo = $data['user_data'] ? "Usuario: {$data['user_data']['email_alerts']} (ID: {$data['user_data']['id_user']})" : "Usuario: Desconocido";
        $processInfo = $data['process_data'] ? "Proceso: {$data['process_data']['generator']} (ID: {$data['process_data']['id_process']})" : "Proceso: Desconocido";
        
        // Determinar si es un bloqueo de bot o acceso normal
        $isBotBlock = isset($data['reason']) && !empty($data['reason']);
        
        if ($isBotBlock) {
            return "🚫 ADMIN - BOT BLOQUEADO\n" .
                   "IP: {$data['ip']}\n" .
                   "User-Agent: {$data['user_agent']}\n" .
                   "Razón: {$data['reason']}\n" .
                   "URL: {$data['url']}\n" .
                   "Tiempo: {$data['timestamp']}\n" .
                   "$userInfo\n" .
                   "$processInfo";
        } else {
            return "👁️ ADMIN - NUEVO ACCESO\n" .
                   "IP: {$data['ip']}\n" .
                   "User-Agent: {$data['user_agent']}\n" .
                   "Acción: {$data['action']}\n" .
                   "URL: {$data['url']}\n" .
                   "Tiempo: {$data['timestamp']}\n" .
                   "$userInfo\n" .
                   "$processInfo";
        }
    }
}
?>
