<?php
/**
 * 📝 Logger - Sistema de Logs Optimizado
 */

namespace AntiBotTr;

class Logger
{
    private $logFile;
    private $blocksToday = 0;
    
    public function __construct()
    {
        $paths = require __DIR__ . '/paths.php';
        $this->logFile = $paths['files']['log'];
        $this->ensureLogDirectory();
    }
    
    /**
     * Asegura que el directorio de logs existe
     */
    private function ensureLogDirectory()
    {
        $paths = require __DIR__ . '/paths.php';
        $logDir = dirname($this->logFile);
        if (!is_dir($logDir)) {
            mkdir($logDir, $paths['permissions']['directory'], true);
        }
    }
    
    public function logBlockedAccess($data)
    {
        $message = "[" . date('Y-m-d H:i:s') . "] BOT BLOCKED: " . 
                   "IP: {$data['ip']}, Reason: {$data['reason']}\n";
        
        file_put_contents($this->logFile, $message, FILE_APPEND | LOCK_EX);
        $this->blocksToday++;
    }
    
    public function logError($message)
    {
        $logMessage = "[" . date('Y-m-d H:i:s') . "] ERROR: {$message}\n";
        file_put_contents($this->logFile, $logMessage, FILE_APPEND | LOCK_EX);
    }
    
    public function getBlocksToday()
    {
        return $this->blocksToday;
    }
}
?>
